<?php $title="Fullwidth + typography" ?>
<?php include("#top.htm");?>

<!-- fullwidth + typography demo -->
<section id="content" class="container_12 clearfix">

	<!-- title -->
	<div class="grid_12">
		<hgroup>
			<h1>Fullwidth + typography</h1>
			<h2>Some awesome subtitle</h2>
		</hgroup>
	</div>
	<!-- / title -->

	<!-- headings/paragraphs demo -->
	<div class="grid_12">

		<h1>Heading 1</h1>
		<p>
			And as the day advanced <span class="amp">&amp;</span> the engine drivers and stokers refused to return to London, the pressure of the flight drove the people in an ever-thickening multitude away from the stations and along the northward-running roads. By midday a Martian had been seen at Barnes, and a cloud of slowly sinking black vapour drove along the Thames and across the flats of Lambeth, cutting off all escape over the bridges in its sluggish advance.
		</p>

		<h2>Heading 2</h2>
		<p>
			<span class="dropcap big">S</span>o he got out of the fury of the panic, and, skirting the Edgware Road, reached Edgware about seven, fasting and wearied, but well ahead of the crowd. Along the road people were standing in the roadway, curious, wondering. He was passed by a number of cyclists, some horsemen, and two motor cars. A mile from Edgware the rim of the wheel broke, and the machine became unridable.
		</p>

		<h3>Heading 3</h3>
		<p>
			It was perhaps a vague idea of making his way to Chelmsford, where some friends of his lived, that at last induced my brother to strike into a quiet lane running eastward. Presently he came upon a stile, and, crossing it, followed a footpath northeastward. He passed near several farmhouses and some little places whose names he did not learn.
		</p>

		<h4>Heading 4</h4>
		<p>
			<span class="dropcap">F</span>or a time he remained in Edgware not knowing what next to do. The flying people increased in number. Many of them, like my brother, seemed inclined to loiter in the place. There was no fresh news of the invaders from Mars.
		</p>

		<h5>Heading 5</h5>
		<p>
			At that time the road was crowded, but as yet far from congested. Most of the fugitives at that hour were mounted on cycles, but there were soon motor cars, hansom cabs, and carriages hurrying along, and the dust hung in heavy clouds along the road to St. Albans.
		</p>

		<h6>Heading 6</h6>
		<p>
			These are <sup>superscript</sup> and <sub>subscript</sub>. One of the ladies, a short woman dressed in white, was simply screaming; the other, a dark, slender figure, slashed at the man who gripped her arm with a whip she held in her disengaged hand.
		</p>

		<hr />

	</div>
	<!-- / headings/paragraphs demo -->

	<!-- left half width -->
	<div class="grid_6">
		<h6>Unordered/ordered lists</h6>
		<ul>
			<li>Lorem ipsum dolor sit amet
				<ul>
					<li>Nested list</li>
					<li>Ad litora torquent per
						<ul>
							<li>Nested list</li>
							<li>Ad litora torquent per </li>
						</ul>
					</li>
				</ul>
			</li>
			<li>Class aptent taciti sociosqu</li>
			<li>Ad litora torquent per </li>
		</ul>

	<hr />

		<h6>Bulleted lists</h6>
		<ul class="red">
			<li>Red bullets list</li>
			<li>Class aptent taciti sociosqu</li>
			<li>Ad litora torquent per </li>
		</ul>
		<ul class="green">
			<li>Green bullets list</li>
			<li>Class aptent taciti sociosqu</li>
			<li>Ad litora torquent per </li>
		</ul>
		<ul class="blue">
			<li>Blue bullets list</li>
			<li>Class aptent taciti sociosqu</li>
			<li>Ad litora torquent per </li>
		</ul>

	<hr />

		<h6>Ordered list</h6>
		<ol>
			<li><em>This is a ordered list</em></li>
			<li><a href="#">This is a list</a></li>
			<li>This is a list
				<ol>
					<li><em>This is a ordered list</em></li>

					<li><a href="#">This is a list</a></li>
					<li>This is a list</li>
					<li>This is a list</li>
				</ol>
			</li>
			<li>This is a list</li>
		</ol>

	<hr />

		<h6>Definition list</h6>
		<dl>
			<dt>A definition list &mdash; this is &lt;dt&gt; </dt>
			<dd>A definition list &mdash; this is  &lt;dd&gt; element.  A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. </dd>
			<dt>A definition list &mdash; this is &lt;dt&gt; </dt>
			<dd>A definition list &mdash; this is  &lt;dd&gt; element.  A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. </dd>
			<dt>A definition list &mdash; this is &lt;dt&gt; </dt>
			<dd>A definition list &mdash; this is  &lt;dd&gt; element.  A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. A definition list &mdash; this is  &lt;dd&gt; element. </dd>
		</dl>

	</div>
	<!-- / left half width -->

	<!-- right half width -->
	<div class="grid_6">

		<div class="info message">This is info message</div>
		<div class="success message">This is success message</div>
		<div class="warning message">This is warning message</div>
		<div class="error message">This is error message</div>

		<h6>Text elements</h6>

		This is <b>bold</b> and <strong>strong</strong><br />
		This is <em>emphasis</em><br />
		This is <b>bold text</b><br />
		This is <i>italic text</i><br />
		This is <cite>cite</cite> and <q>quote</q> tag<br />


		This is <small>small text</small><br />
		This is <del>deleted text</del><br />

		This is <ins>inserted text</ins><br />

		This is <abbr title="title">abbreviation</abbr><br />

		This is <dfn>defining instance</dfn><br />

		This is <var>variable</var> and <samp>sample output</samp><br />
		This is <q>inline quote</q> <br />

		These are <sup>superscript</sup> and <sub>subscript</sub><br />
		<address>This is address example</address> <br />

		<!--
		Elements marked as obsolete in HTML5 (also styled), commented out for validation purposes
		This is <strike>strike</strike><br />
		This is <acronym>acronym</acronym><br />
		This is <big>big text</big><br />
		This is <tt>teletype</tt> and <kbd>user input</kbd><br />
		-->
	<hr />

		<h6>Pullquotes</h6>
		<p>
			And as the day advanced <span class="amp">&amp;</span> the engine drivers and stokers refused to return to London, the pressure of the flight drove the people in an ever-thickening
			<span class="pullquote left">This is pullquote left. By midday a Martian had been seen at Barnes, and a cloud of slowly sinking black vapour.</span>multitude away from the stations and along the northward-running roads. By midday a Martian had been seen at Barnes, and a cloud of slowly sinking black vapour drove along the Thames and

			across the flats of Lambeth, cutting off all escape over the bridges in its sluggish advance.
			And as the day advanced <span class="amp">&amp;</span> the engine drivers and stokers refused to return to London, the pressure of the flight drove the people in an ever-thickening multitude away from the stations and along the northward-running roads. By midday a

			<span class="pullquote right">This is pullquote right. By midday a Martian had been seen at Barnes, and a cloud of slowly sinking black vapour.</span>

			Martian had been seen at Barnes, and a cloud of slowly sinking black vapour drove along the Thames and across the flats of Lambeth, cutting off all escape over the bridges in its sluggish advance.
		</p>
	</div>
	<!-- / right half width -->

	<div class="clear"></div>
	
	<!-- left half width -->
	<div class="grid_6">
		<blockquote>
			<p>
				This is a blockquote. Phasellus imperdiet, ligula ac vestibulum tempor, lectus orci tempor leo, in ullamcorper lectus leo ornare mauris. Nulla augue magna, rutrum consectetur facilisis facilisis, egestas et risus.
				<span>&#8212;Author</span>
			</p>
		</blockquote>

		<h6>Buttons</h6>

			<a class="button" href="#">Small button</a>

			<a class="big button" href="#">Big button</a>
			<br />

			<a class="actionbutton" href="#">Action button</a>
			<br />

		<hr />
	</div>
	<!-- / left half width -->

	<!-- right half width -->
	<div class="grid_6">
		<hr />

		<h6>Tables</h6>
		<!-- table example -->
		<table>
		<caption><em>A test table with a caption, thead, tfoot, and tbody elements</em></caption>
			<colgroup>

				<col id="date" />
				<col id="user" />
				<col id="info" />
				<col id="desc" />
			</colgroup>
			<thead>
				<tr>
				  <th scope="col">Date</th>

				  <th scope="col">User</th>
				  <th scope="col">Info</th>
				  <th scope="col">Description</th>
				</tr>
			</thead>
			<tfoot>
				<tr>

				  <td colspan="4">Footer information phasellus imperdiet, ligula ac vestibulum tempor</td>
				</tr>
			</tfoot>
			<tbody>
				<tr>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>

					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
				</tr>
				<tr>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>

					<td>lorem ipsum</td>
				</tr>
				<tr>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>

				</tr>
				<tr>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
				</tr>

				<tr>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
					<td>lorem ipsum</td>
				</tr>
			</tbody>
		</table>
		<!-- / table example -->

	</div>
	<!-- / right half width -->


<div class="grid_12">
	<h6>Code/Pre tags</h6>
</div>

<!-- left half width -->
<div class="grid_6">
<code>// code
var basefont=$('#basefont').val() * 1;
// lineheight - 18px
var lineheight=$('#lineheight').val() * 1;
// calculated line height: (1.5)
var baseheight=lineheight / basefont;
$('#baseheight').html(Round(baseheight));
</code>
</div>
<!-- / left half width -->

<!-- right half width -->
<div class="grid_6">
<pre>// preformatted
var basefont=$('#basefont').val() * 1;
// lineheight - 18px
var lineheight=$('#lineheight').val() * 1;
// calculated line height: (1.5)
var baseheight=lineheight / basefont;
$('#baseheight').html(Round(baseheight));
</pre>
</div>
<!-- / right half width -->

</section>
<!-- / fullwidth + typography demo -->

<?php include("#bottom.htm"); ?>